import {world, EquipmentSlot, GameMode, Player} from "@minecraft/server";

function applyDurabilityDamage(source, mainhand) {
    if (source.getGameMode() === GameMode.creative) return;

    const itemStack = mainhand.getItem();
    if (!itemStack) return;

    const durability = itemStack.getComponent("minecraft:durability");
    if (!durability) return;

    const enchantable = itemStack.getComponent("minecraft:enchantable");
    const unbreakingLevel = enchantable?.getEnchantment("unbreaking")?.level ?? 0;

    const damageChance = durability.getDamageChance(unbreakingLevel) / 100;

    if (Math.random() > damageChance) return;

    if (durability.damage >= durability.maxDurability - 1) {
        mainhand.setItem(undefined);
        source.playSound("random.break");
    } else {
        durability.damage++;
        mainhand.setItem(itemStack);
    }
}

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('dmss:cherry_wand', {
        onUse(source) {
            const sapling = source.getBlockFromViewDirection({ maxDistance: 5 });
            if (!sampilg || sapling.block.typeId !=="minecraft:cherry_sapling") {
                source.sendMessage("Not the right block!Search for a cherry sapling...");
                return;
            } else {
                const saplingPos = {
                    x: sapling.block.location.x,
                    y: sapling.block.location.y,
                    z: sapling.block.location.z
                };
                const offsetPos = {
                    x: saplingPos.x + 2,
                    y: saplingPos.y,
                    z: saplingPos.z + 2
                };
                const dimension = source.dimension;
                dimension.spawnParticle("minecraft:happy_villager", saplingPos);
                dimension.loadStructure("cherry_tree").then(structure => {
                    structure.place(offsetPos);
                });
                
                if (!(source instanceof Player)) return;
                const equippable = source.getComponent("minecraft:equippable");
                if (!equippable) return;
                
                const mainhand = equippable.getEquipmentSlot(EquipmentSlot.Mainhand);
                if (!mainhand.hasItem()) return;
                
                applyDurabilityDamage(source, mainhand);
            }
        }
    });
});
